/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.core.CPU;
import jace.core.Card;
import jace.core.Computer;
import jace.core.Device;
import jace.core.TimedDevice;
import jace.core.Video;
import java.util.ArrayList;
import java.util.List;

public class Motherboard
extends TimedDevice {
    static final Computer computer = Computer.getComputer();
    static final CPU cpu = computer.getCpu();
    static final Video video = computer.getVideo();
    static final Card[] cards = computer.getMemory().getAllCards();
    public static final List<Device> miscDevices = new ArrayList<Device>();
    public static boolean soundEnabled = false;
    public static long SPEED = 1020500L;

    protected String getDeviceName() {
        return "Motherboard";
    }

    public void tick() {
        cpu.doTick();
        video.doTick();
        for (Card c : cards) {
            if (c == null) continue;
            c.motherboardTick();
        }
        for (Device m : miscDevices) {
            m.doTick();
        }
    }

    protected void resync() {
        super.resync();
    }

    public long cyclesPerSecond() {
        return Computer.getComputer().isAccelorated() ? Long.MAX_VALUE : SPEED;
    }
}

